
clear;
clc;
close all;

% Czestotliwosc probkowania
Fs=2000;

%parametry sygnau
fsyg=10;
ok=1/fsyg;
A=1;
faza=0;
sks=0;

T=1/Fs;
% Czas analizy
t=0:T:((5*ok)-T);

y=A*square(2*pi*fsyg*t+faza)+sks;
%y=A*sawtooth(2*pi*fsyg*t+faza, 0)+sks;

% Projekt filtra NOI - funkcja ellip()
N=8;
Rp=0.1;
Rs=50;
wn=[80]/(Fs/2);
[b,a]=ellip(N,Rp,Rs,wn);

% Projekt filtra SOI - funkcja firpm()
% a=1;
% N=500;
% Ho=[1 1 0 0];
% fo=[0 75 85 (Fs/2)]/(Fs/2);
% b=firpm(N,fo,Ho);

figure(1)
freqz(b,a,512,Fs);

yf = filter(b,a,y);

figure(2)
subplot(211)
plot(t,y,'-g');
hold on
plot(t,yf,'-r');

axis tight
grid on;
xlabel('Czas')
ylabel('Amplituda')
title('Sygnal')